<?php
namespace ElementPack\Modules\FancySlider\Widgets;

use element_pack_helper;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Fancy_Slider extends Widget_Base {

	public function get_name() {
		return 'bdt-fancy-slider';
	}

	public function get_title() {
		return BDTEP . esc_html__( 'Fancy Slider', 'bdthemes-element-pack' );
	}

	public function get_icon() {
		return 'bdt-wi-fancy-slider';
	}

	public function get_categories() {
		return [ 'element-pack' ];
	}

	public function get_keywords() {
		return [ 'card', 'slider', 'fancy', 'slideshow', 'advanced' ];
	}

	public function get_style_depends() {
		return [ 'ep-fancy-slider' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded' ];
	}

	// public function get_custom_help_url() {
	// 	return 'https://youtu.be/GACXtqun5Og';
	// }

	protected function _register_controls() {
		$this->register_query_section_controls();
	}

	private function register_query_section_controls() {

		$this->start_controls_section(
			'section_content_fancy_slider',
			[
				'label' => esc_html__( 'Fancy Slider', 'bdthemes-element-pack' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'         => 'thumbnail_size',
				'label'        => esc_html__( 'Image Size', 'bdthemes-element-pack' ),
				'exclude'      => [ 'custom' ],
				'default'      => 'medium',
				'prefix_class' => 'bdt-fancy-slider--thumbnail-size-',
			]
		);

		$this->add_control(
			'slider_min_height',
			[
				'label' => esc_html__('Minimum Height', 'bdthemes-prime-slider'),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 1024,
					],
				],
			]
		);

		$this->add_responsive_control(
			'slide_text_align',
			[
				'label'   => __( 'Alignment', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-align-right',
					],
					'justify' => [
						'title' => __( 'Justified', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-align-justify',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Sub Title', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_description',
			[
				'label'   => esc_html__( 'Show Description', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_slide_image',
			[
				'label'   => esc_html__( 'Show Slide Iamge', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_dotnav',
			[
				'label'   => esc_html__( 'Show Dotnav', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_sliders',
			[
				'label' => esc_html__( 'Slider Item', 'bdthemes-element-pack' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slides',
			[
				'label' => esc_html__( 'Item', 'bdthemes-element-pack' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'title' => esc_html__( 'Fancy Slider Item One', 'bdthemes-element-pack' ),
						'slide_image' => ['url' => BDTEP_ASSETS_URL . 'images/gallery/item-4.png'],
					],
					[
						'title' => esc_html__( 'Fancy Slider Item Two', 'bdthemes-element-pack' ),
						'slide_image' => ['url' => BDTEP_ASSETS_URL . 'images/gallery/item-6.png']
					],
					[
						'title' => esc_html__( 'Fancy Slider Item Three', 'bdthemes-element-pack' ),
						'slide_image' => ['url' => BDTEP_ASSETS_URL . 'images/gallery/item-7.png']
					],
				],
				'fields' => [
					
					[
						'name'        => 'sub_title',
						'label'       => esc_html__( 'Sub Title', 'bdthemes-element-pack' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => esc_html__( 'Subtitle Goes Here' , 'bdthemes-element-pack' ),
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
					],

					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdthemes-element-pack' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => esc_html__( 'Slide Title Here' , 'bdthemes-element-pack' ),
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
					],
					
					[
						'name'          => 'title_link',
						'label'         => esc_html__( 'Title Link', 'bdthemes-element-pack' ),
						'type'          => Controls_Manager::URL,
						'default'       => ['url' => ''],
						'show_external' => false,
						'dynamic'       => [ 'active' => true ],
						'condition'     => [
							'title!' => ''
						]
					],

					[
						'name'        => 'description',
						'label'       => esc_html__( 'Description', 'bdthemes-element-pack' ),
						'type'        => Controls_Manager::TEXTAREA,
						'default'     => esc_html__( 'Lorem ipsum dolor sit amet consectetur, adipisicing elit. Recusandae voluptate repellendus magni illo ea animi?' , 'bdthemes-element-pack' ),
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
					],

					[
						'name'        => 'slide_button',
						'label'       => esc_html__( 'Button Text', 'bdthemes-element-pack' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => esc_html__( 'Read More' , 'bdthemes-element-pack' ),
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
					],
					
					[
						'name'          => 'button_link',
						'label'         => esc_html__( 'Button Link', 'bdthemes-element-pack' ),
						'type'          => Controls_Manager::URL,
						'default'       => ['url' => '#'],
						'show_external' => false,
						'dynamic'       => [ 'active' => true ],
						'condition'     => [
							'slide_button!' => ''
						]
					],

					[
						'name'    => 'slide_image',
						'label'   => esc_html__( 'Image', 'bdthemes-element-pack' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default' => [
							'url' => BDTEP_ASSETS_URL . 'images/gallery/item-'.rand(1,3).'.png',
						],
					],

				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_animation',
			[
				'label' => esc_html__( 'Animation', 'bdthemes-element-pack' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'   => esc_html__( 'Autoplay', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'autoplay_interval',
			[
				'label'     => esc_html__( 'Autoplay Interval', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 7000,
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label' => esc_html__( 'Pause on Hover', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'speed',
			[
				'label'              => esc_html__( 'Animation Speed', 'bdthemes-element-pack' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 500,
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();


		//Style
		$this->start_controls_section(
			'section_style_slider',
			[
				'label' => esc_html__( 'Slider Item', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_background',
			[
				'label'     => esc_html__( 'Background', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'item_border',
				'label'       => esc_html__( 'Border', 'bdthemes-element-pack' ),
				'selector'    => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items',
			]
		);

		$this->add_control(
			'item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'item_content_padding',
			[
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_iamge',
			[
				'label'     => esc_html__( 'Image', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_slide_image' => [ 'yes' ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'image_background',
				'selector'  => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image:after',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'iamge_border',
				'label'       => esc_html__( 'Border', 'bdthemes-element-pack' ),
				'selector'    => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image, {{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image img',
			]
		);

		$this->add_control(
			'iamge_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image, {{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image img, {{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'iamge_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image, {{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-slide-image img',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => esc_html__( 'Title', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_spacing',
			[
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-title' => 'padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_sub_title',
			[
				'label'     => esc_html__( 'Subtitle', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_subtitle' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-subtitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_title_spacing',
			[
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sub_title_typography',
				'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-subtitle',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_description',
			[
				'label'     => esc_html__( 'Description', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_description' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'description_spacing',
			[
				'label'     => esc_html__( 'Spacing', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-description' => 'padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'description_typography',
				'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-description',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_button',
			[
				'label'     => esc_html__( 'Button', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_button' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_background',
				'selector'  => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'button_border',
				'label'       => esc_html__( 'Border', 'bdthemes-element-pack' ),
				'selector'    => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'border_radius_advanced_show!' => 'yes',
				],
			]
		);

		$this->add_control(
			'border_radius_advanced_show',
			[
				'label' => __( 'Advanced Radius', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'border_radius_advanced',
			[
				'label'       => esc_html__('Radius', 'bdthemes-element-pack'),
				'description' => sprintf(__('For example: <b>%1s</b> or Go <a href="%2s" target="_blank">this link</a> and copy and paste the radius value.', 'bdthemes-element-pack'), '30% 70% 82% 18% / 46% 62% 38% 54%', 'https://9elements.github.io/fancy-border-radius/'),
				'type'        => Controls_Manager::TEXT,
				'size_units'  => [ 'px', '%' ],
				'separator'   => 'after',
				'default'     => '30% 70% 82% 18% / 46% 62% 38% 54%',
				'selectors'   => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a'     => 'border-radius: {{VALUE}}; overflow: hidden;',
				],
				'condition' => [
					'border_radius_advanced_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_padding',
			[
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'button_typography',
				'label'     => esc_html__( 'Typography', 'bdthemes-element-pack' ),
				'selector'  => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a:hover'  => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_hover_background',
				'selector'  => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a:hover',
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'button_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_hover_box_shadow',
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow-items .bdt-slideshow-item .bdt-fancy-slider-content .bdt-fancy-slider-button a:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_navigation_dots',
			[
				'label'     => esc_html__( 'Dots', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_dotnav' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_dots_style' );

		$this->start_controls_tab(
			'tab_dots_normal',
			[
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'dots_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li a' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'dots_width',
			[
				'label' => esc_html__( 'Width', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'dots_height',
			[
				'label' => esc_html__( 'Height', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li a' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'dots_radius',
			[
				'label'      => esc_html__( 'Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_dots_active',
			[
				'label' => esc_html__( 'Active', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'active_dot_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li.bdt-active a' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dots_active_shadow',
				'selector' => '{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li.bdt-active a',
			]
		);

		$this->add_control(
			'dots_active_width',
			[
				'label' => esc_html__( 'Width', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li.bdt-active a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'dots_active_height',
			[
				'label' => esc_html__( 'Height', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-fancy-slider .bdt-slideshow .bdt-dotnav li.bdt-active a' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


	}
	
	protected function render_header() {
		$settings        = $this->get_settings_for_display();
		$ratio           = '1280:720';
		

		$slider_settings['bdt-slideshow'] = wp_json_encode(array_filter([
			"animation"         => 'fade',
			"ratio"             => $ratio,
			"min-height"        => ($settings["slider_min_height"]["size"]) ? $settings["slider_min_height"]["size"] : 480,
			"autoplay"          => ("yes" === $settings["autoplay"]) ? true : false,
			"autoplay-interval" => $settings["autoplay_interval"],
			"pause-on-hover"    => ("yes" === $settings["pause_on_hover"]) ? true : false,
	    ]));


		?>
		<div class="bdt-fancy-slider-container">
			<div class="bdt-fancy-slider">
				<div <?php echo element_pack_helper::attrs($slider_settings); ?>>
					<div class="bdt-position-relative bdt-visible-toggle">
						<ul class="bdt-slideshow-items">
		<?php
	}

	protected function render_footer() {
		$settings    = $this->get_settings_for_display();

			?>
				</ul>

					<?php $this->render_dotnav(); ?>
						
					</div>
				</div>
			</div>
		</div>
		<?php
	}

	protected function render_dotnav() {
		$settings    = $this->get_settings_for_display();

		?>

			<?php if ( 'yes' == $settings['show_dotnav'] ) : ?>
				<ul class="bdt-dotnav bdt-position-top-center">

					<?php		
					$bdt_counter    = 0;
					$slideshow_dots = $this->get_settings('slides');
							
					foreach ( $slideshow_dots as $dot ) :
						
						echo '<li class="bdt-slideshow-dotnav bdt-active" bdt-slideshow-item="'.$bdt_counter.'"><a href="#"></a></li>';
						$bdt_counter++;

					endforeach; ?>
				</ul>
			<?php endif; ?>

		<?php
	}

	protected function rendar_item_image( $content ) {
        $settings = $this->get_settings();
        $thumb_url = Group_Control_Image_Size::get_attachment_image_src( $content['slide_image']['id'], 'thumbnail_size', $settings);

        if ( ! $thumb_url ) {
        	$thumb_url = $content['slide_image']['url'];
        }

		?>

            <img src="<?php echo esc_url( $thumb_url); ?>" alt="<?php echo esc_html( $content['title'] ); ?>">

        <?php
	}

	protected function rendar_item_content($content) {
		$settings = $this->get_settings_for_display();

		?>
		
				<div class="bdt-fancy-slider-image">
					<?php if ($content['slide_image'] && ( 'yes' == $settings['show_slide_image'] )) : ?>
						<div class="bdt-slide-image">
							<?php $this->rendar_item_image($content); ?>
						</div>
					<?php endif; ?>
				</div>

				<div class="bdt-fancy-slider-content">
					<?php if ($content['sub_title'] && ( 'yes' == $settings['show_subtitle'] )) : ?>
						<div class="bdt-fancy-slider-subtitle">
							<?php echo wp_kses_post($content['sub_title']); ?>
						</div>
					<?php endif; ?>
		
					<?php if ($content['title'] && ( 'yes' == $settings['show_title'] )) : ?>
						<h2 class="bdt-fancy-slider-title">
							<?php if ( '' !== $content['title_link']['url'] ) : ?>
								<a href="<?php echo esc_url( $content['title_link']['url'] ); ?>">
							<?php endif; ?>
								<?php echo wp_kses_post($content['title']); ?>
							<?php if ( '' !== $content['title_link']['url'] ) : ?>
								</a>
							<?php endif; ?>
						</h2>
					<?php endif; ?>
		
					<?php if ($content['description'] && ( 'yes' == $settings['show_description'] )) : ?>
						<div class="bdt-fancy-slider-description">
							<?php echo wp_kses_post($content['description']); ?>
						</div>
					<?php endif; ?>
		
					<?php if ($content['slide_button'] && ( 'yes' == $settings['show_button'] )) : ?>
						<div class="bdt-fancy-slider-button">
							<?php if ( '' !== $content['button_link']['url'] ) : ?>
								<a href="<?php echo esc_url( $content['button_link']['url'] ); ?>">
							<?php endif; ?>
								<?php echo wp_kses_post($content['slide_button']); ?>
							<?php if ( '' !== $content['button_link']['url'] ) : ?>
								</a>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>

		<?php
	}

	protected function render() {
		$settings         = $this->get_settings_for_display();

		$this->render_header();

			foreach ( $settings['slides'] as $slide ) : ?>
					    
					<li class="bdt-slideshow-item elementor-repeater-item-<?php echo esc_attr($slide['_id']); ?>">
					
						<?php $this->rendar_item_content($slide); ?>
						
			        </li>

				<?php endforeach;

		$this->render_footer();
	}
}
